/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.front;

import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.block.AutopilotSignBlock;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.HitboxEntity;
import io.github.foundationgames.automobility.item.AutopilotSignBlockItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AutopilotFrontAttachment
extends FrontAttachment {
    public static final int MAX_HEADING_COMMAND_TIME = 6000;
    @Nullable
    private AutopilotSignBlock.Heading currentHeading = null;
    private int headingTimeLimit = 0;
    private int animationTimer = 0;
    private int honkTimer = -6;
    private int impatience = 0;

    public AutopilotFrontAttachment(FrontAttachmentType<?> type, AutomobileEntity automobile) {
        super(type, automobile);
    }

    @Override
    public boolean canDrive(Entity entity) {
        return false;
    }

    @Override
    public boolean isProvidingAlternativeInputs(AutomobileEntity automobile, @Nullable Entity driver) {
        return true;
    }

    @Override
    public void provideAlternativeInputs(AutomobileEntity automobile, AutomobileEntity.Input input, @Nullable Entity driver) {
        int threshold;
        this.honkTimer -= input.accelerating ? 6 : 1;
        if (this.honkTimer < -10) {
            this.honkTimer = -10;
        }
        boolean beingInterrupted = false;
        if (this.currentHeading == null) {
            input.clearInputs();
        } else {
            boolean burnout;
            Vec3 dirHeading = automobile.getLookAngle();
            boolean somethingInTheWay = false;
            double width = 0.8 * (double)automobile.getBbWidth();
            AABB box = new AABB(-width, -2.0, -width, width, 4.0, width);
            box = box.move(this.pos().add(dirHeading.scale(1.0 + 1.75 * width)));
            for (HitboxEntity e : this.world().getEntitiesOfClass(HitboxEntity.class, box)) {
                if (automobile.isOneOfMyHitboxes(e) || automobile.isInvulnerable() && !e.automobile().isInvulnerable()) continue;
                somethingInTheWay = true;
                break;
            }
            beingInterrupted |= somethingInTheWay;
            if (!somethingInTheWay) {
                for (HitboxEntity e : this.world().getEntitiesOfClass(LivingEntity.class, box.inflate(1.25))) {
                    if (e.isUsingItem() && e.getItemInHand(e.getUsedItemHand()).getItem() instanceof AutopilotSignBlockItem) {
                        Vec3 meToE;
                        Vec3 eLooking = e.getLookAngle();
                        if (!(eLooking.dot(meToE = e.position().subtract(this.pos()).normalize()) < 0.0)) continue;
                        somethingInTheWay = true;
                        break;
                    }
                    if (this.honkTimer >= -3) continue;
                    this.honkTimer = 10 + this.world().getRandom().nextInt(15);
                    beingInterrupted = true;
                }
            }
            Vec3 autoPos = this.autoPos();
            Vec3 autoMovement = automobile.getMeasuredMovement();
            Vec3 dirAlongPath = this.currentHeading.dir();
            double offCosine = dirHeading.dot(dirAlongPath);
            Vec3 pathToPath = this.currentHeading.pathToPath(autoPos);
            double distToPath = pathToPath.length();
            Vec3 dirToPath = pathToPath.normalize();
            double autoSpeedIntoPath = this.currentHeading.stop() || somethingInTheWay ? autoMovement.length() : Math.max(0.0, -autoMovement.dot(dirToPath));
            double favorDirToPath = Math.clamp(distToPath * 0.1, 0.0, 1.0);
            if (somethingInTheWay || this.currentHeading.stop() && this.currentHeading.origin().distanceToSqr(autoPos) < 25.0 + 49.0 * autoMovement.lengthSqr()) {
                input.accelerating = burnout = offCosine > 0.0 && automobile.getTurboCharge() < 30;
                input.braking = burnout || autoSpeedIntoPath > 0.2;
                favorDirToPath = Math.sqrt(favorDirToPath);
            } else {
                burnout = automobile.burningOut() ? offCosine > -0.8 : offCosine > 0.2;
                input.accelerating = burnout || autoSpeedIntoPath * autoSpeedIntoPath * distToPath * distToPath < (double)(5.0f + 2.0f / automobile.getHandling());
                input.braking = burnout;
            }
            Vector3f dirHeadingF = dirHeading.toVector3f().mul(1.0f, 0.0f, 1.0f);
            Vector3f dirDesiredHeadingF = dirAlongPath.lerp(dirToPath, favorDirToPath).normalize().toVector3f().mul(1.0f, 0.0f, 1.0f);
            double headingToPathDir = dirHeadingF.angleSigned((Vector3fc)dirDesiredHeadingF, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)) / 1.5707964f;
            input.steering = (float)Math.clamp(headingToPathDir, -1.0, 1.0);
            if (!burnout) {
                float offset = (float)dirAlongPath.cross(dirHeading).length();
                float damp = (float)Mth.clamp((double)(Math.abs(distToPath * 0.2) + Math.sqrt(offset)), (double)0.0, (double)1.0);
                input.steering *= damp * damp;
            }
        }
        if (beingInterrupted) {
            ++this.impatience;
        } else if (this.impatience > 0) {
            this.impatience = input.accelerating ? Math.max(0, (int)(0.9 * (double)this.impatience) - 4) : --this.impatience;
        }
        float wantsToHonk = 1.0f + 1.0f / (-1.0f - 0.007f * (float)Math.max(0, this.impatience - 60));
        if (this.world().getRandom().nextFloat() < wantsToHonk * wantsToHonk && this.honkTimer <= (threshold = (int)(-10.0f + 5.0f * (this.world().getRandom().nextFloat() * wantsToHonk)))) {
            int duration;
            this.honkTimer = duration = (int)(3.0f + wantsToHonk * (float)this.world().getRandom().nextInt(17));
        }
        input.holdingHorn = this.honkTimer > 0;
    }

    protected Vec3 autoPos() {
        return this.automobile().position().add(0.0, 0.5, 0.0);
    }

    public void notifyHeadingCommand(AutopilotSignBlock.Heading heading) {
        Vec3 autoPos = this.autoPos();
        if (heading.inFrontOfLimitPlane(autoPos) && heading.withinReasonableDistance(autoPos)) {
            if (this.currentHeading != null && this.currentHeading.origin().distanceToSqr(autoPos) < heading.origin().distanceToSqr(autoPos)) {
                return;
            }
            this.currentHeading = heading;
            this.headingTimeLimit = 6000;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.world().isClientSide()) {
            if (this.currentHeading != null && !this.currentHeading.withinReasonableDistance(this.autoPos())) {
                this.currentHeading = null;
            }
            float anim = 0.0f;
            if (this.currentHeading != null) {
                anim = this.currentHeading.stop() ? 2.0f : 1.0f;
            }
            this.updateTrackedAnimation(anim);
            if (this.headingTimeLimit > 0) {
                --this.headingTimeLimit;
                if (this.headingTimeLimit <= 0) {
                    this.currentHeading = null;
                }
            }
        }
        ++this.animationTimer;
        if (this.animationTimer >= 60) {
            this.animationTimer = 0;
        }
    }

    @Override
    public void writeNbt(CompoundTag nbt, HolderLookup.Provider registry) {
        super.writeNbt(nbt, registry);
        if (this.currentHeading != null) {
            nbt.put("Command", this.currentHeading.toNbt());
        }
        nbt.putInt("timeout", this.headingTimeLimit);
        nbt.putInt("honk_time", this.honkTimer);
        nbt.putInt("impatience", this.impatience);
    }

    @Override
    public void readNbt(CompoundTag nbt, HolderLookup.Provider reg) {
        super.readNbt(nbt, reg);
        this.currentHeading = nbt.contains("Command") ? AutopilotSignBlock.Heading.fromNbt(nbt.getCompound("Command")) : null;
        this.headingTimeLimit = nbt.getInt("timeout");
        this.honkTimer = nbt.getInt("honk_time");
        this.impatience = nbt.getInt("impatience");
    }

    public int getAnimationTimer() {
        return this.animationTimer;
    }

    public State getState() {
        int anim = Math.clamp((long)((int)this.animation()), 0, State.values().length);
        return State.values()[anim];
    }

    public static enum State {
        IDLE(16775392, 16756224, 15, 0),
        GO(15269883, 65493, 12, 4),
        HALT(0xFFBDBD, 0xFF0000, 0, 0);

        public final int lightColor;
        public final int glowColor;
        public final int flashPeriod;
        public final int flashSubPeriod;

        private State(int lightColor, int glowColor, int flashPeriod, int flashSubPeriod) {
            this.lightColor = lightColor;
            this.glowColor = glowColor;
            this.flashPeriod = flashPeriod;
            this.flashSubPeriod = flashSubPeriod;
        }
    }
}

